#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private Quantum.Quantum_CSI[] cacheQuantum_CSI;
		private Quantum.Quantum_CurrencyArray[] cacheQuantum_CurrencyArray;
		private Quantum.Quantum_CurrencyHeatmap[] cacheQuantum_CurrencyHeatmap;
		private Quantum.Quantum_CurrencyMatrix[] cacheQuantum_CurrencyMatrix;
		private Quantum.Quantum_DynamicAccumulationAndDistribution[] cacheQuantum_DynamicAccumulationAndDistribution;
		private Quantum.Quantum_DynamicPricePivots[] cacheQuantum_DynamicPricePivots;
		private Quantum.Quantum_DynamicVolatility[] cacheQuantum_DynamicVolatility;
		private Quantum.Quantum_EURX[] cacheQuantum_EURX;
		private Quantum.Quantum_GBPX[] cacheQuantum_GBPX;
		private Quantum.Quantum_JPYX[] cacheQuantum_JPYX;
		private Quantum.Quantum_LiveCamarillaLevels[] cacheQuantum_LiveCamarillaLevels;
		private Quantum.Quantum_MarketStrengthIndicator[] cacheQuantum_MarketStrengthIndicator;
		private Quantum.Quantum_RenkoOptimiser[] cacheQuantum_RenkoOptimiser;
		private Quantum.Quantum_TickSpeedometer[] cacheQuantum_TickSpeedometer;
		private Quantum.Quantum_TrendMonitor[] cacheQuantum_TrendMonitor;
		private Quantum.Quantum_Trends[] cacheQuantum_Trends;
		private Quantum.Quantum_USDX[] cacheQuantum_USDX;
		private Quantum.Quantum_Volume[] cacheQuantum_Volume;
		private Quantum.Quantum_VPOC[] cacheQuantum_VPOC;
		private Quantum.Quantum_VRSI[] cacheQuantum_VRSI;
		private Quantum.Quantum_VWAPPro[] cacheQuantum_VWAPPro;

		
		public Quantum.Quantum_CSI Quantum_CSI(int period, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool alertOverbought, bool alertOversold, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_CSI(Input, period, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, alertOverbought, alertOversold, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_CurrencyArray Quantum_CurrencyArray(int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnOverbought, bool alertOnOversold, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_CurrencyArray(Input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnOverbought, alertOnOversold, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_CurrencyHeatmap Quantum_CurrencyHeatmap(int lookBack, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_CurrencyHeatmap(Input, lookBack, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_CurrencyMatrix Quantum_CurrencyMatrix(int lookBack, bool classicColors, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_CurrencyMatrix(Input, lookBack, classicColors, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_DynamicAccumulationAndDistribution Quantum_DynamicAccumulationAndDistribution(int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_DynamicAccumulationAndDistribution(Input, period, offset, labelPosition, clusterFactor, lineStyle, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_DynamicPricePivots Quantum_DynamicPricePivots(int offset, bool alertIsolatedHigh, bool alertIsolatedLow, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_DynamicPricePivots(Input, offset, alertIsolatedHigh, alertIsolatedLow, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_DynamicVolatility Quantum_DynamicVolatility(int offset, int sensitivity, bool alertVolatility, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_DynamicVolatility(Input, offset, sensitivity, alertVolatility, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_EURX Quantum_EURX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_EURX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_GBPX Quantum_GBPX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_GBPX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_JPYX Quantum_JPYX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_JPYX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_LiveCamarillaLevels Quantum_LiveCamarillaLevels(bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor, bool alertAnalysisUpdate, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_LiveCamarillaLevels(Input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor, alertAnalysisUpdate, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_MarketStrengthIndicator Quantum_MarketStrengthIndicator(int lookBack, bool enableInstrument1, bool enableInstrument2, bool enableInstrument3, bool enableInstrument4, bool enableInstrument5, bool showInstrument0, bool showInstrument1, bool showInstrument2, bool showInstrument3, bool showInstrument4, bool showInstrument5, bool alertOverbought, bool alertOversold, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return Quantum_MarketStrengthIndicator(Input, lookBack, enableInstrument1, enableInstrument2, enableInstrument3, enableInstrument4, enableInstrument5, showInstrument0, showInstrument1, showInstrument2, showInstrument3, showInstrument4, showInstrument5, alertOverbought, alertOversold, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Quantum.Quantum_RenkoOptimiser Quantum_RenkoOptimiser(int aTRPeriod, int buttonSize, bool alertOnNewRenko, bool alertOnBullishTrendShift, bool alertOnBearishTrendShift, bool alertOnTrendShift, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_RenkoOptimiser(Input, aTRPeriod, buttonSize, alertOnNewRenko, alertOnBullishTrendShift, alertOnBearishTrendShift, alertOnTrendShift, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_TickSpeedometer Quantum_TickSpeedometer(int period, bool dockRight, bool dockDown, bool alertOnCurrentSpeedChange, bool alertOnAverageSpeedChange, bool alertOnFibTickChange, int alertRearmTime, string alertSoundFile, bool alertCurSpeedOnFormingCandle)
		{
			return Quantum_TickSpeedometer(Input, period, dockRight, dockDown, alertOnCurrentSpeedChange, alertOnAverageSpeedChange, alertOnFibTickChange, alertRearmTime, alertSoundFile, alertCurSpeedOnFormingCandle);
		}

		public Quantum.Quantum_TrendMonitor Quantum_TrendMonitor(int tolerance, bool showTrendLine, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return Quantum_TrendMonitor(Input, tolerance, showTrendLine, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Quantum.Quantum_Trends Quantum_Trends(int sensitivityToCongestion, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return Quantum_Trends(Input, sensitivityToCongestion, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Quantum.Quantum_USDX Quantum_USDX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_USDX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_Volume Quantum_Volume(bool displayHighVolumeLine, bool displayLowVolumeLine, bool alertHighVolume, bool alertLowVolume, bool alertAveVolume, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_Volume(Input, displayHighVolumeLine, displayLowVolumeLine, alertHighVolume, alertLowVolume, alertAveVolume, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_VPOC Quantum_VPOC(bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, bool displayLeft, int lookBackPeriod, int regionCount, VPOCSRLineCount sRLineCount, bool alertVPOCCross, bool alertHVNLVNCross, int alertRearmTime, string alertSoundFile)
		{
			return Quantum_VPOC(Input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, displayLeft, lookBackPeriod, regionCount, sRLineCount, alertVPOCCross, alertHVNLVNCross, alertRearmTime, alertSoundFile);
		}

		public Quantum.Quantum_VRSI Quantum_VRSI(int period, bool alertSentiment, bool alertZeroCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return Quantum_VRSI(Input, period, alertSentiment, alertZeroCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Quantum.Quantum_VWAPPro Quantum_VWAPPro(QTWAPTypes wAPType, int wAPOpacity, bool showULB, bool fillRegions, double multiplier, string wAPID, int mVWAPPeriod, int mVWAPStdDevPeriod, int tWAPPeriod, int tWAPStdDevPeriod, QTWAPPeriod wAPPeriod, bool alertCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return Quantum_VWAPPro(Input, wAPType, wAPOpacity, showULB, fillRegions, multiplier, wAPID, mVWAPPeriod, mVWAPStdDevPeriod, tWAPPeriod, tWAPStdDevPeriod, wAPPeriod, alertCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}


		
		public Quantum.Quantum_CSI Quantum_CSI(ISeries<double> input, int period, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool alertOverbought, bool alertOversold, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_CSI != null)
				for (int idx = 0; idx < cacheQuantum_CSI.Length; idx++)
					if (cacheQuantum_CSI[idx].Period == period && cacheQuantum_CSI[idx].ShowUSD == showUSD && cacheQuantum_CSI[idx].ShowEUR == showEUR && cacheQuantum_CSI[idx].ShowGBP == showGBP && cacheQuantum_CSI[idx].ShowCHF == showCHF && cacheQuantum_CSI[idx].ShowJPY == showJPY && cacheQuantum_CSI[idx].ShowCAD == showCAD && cacheQuantum_CSI[idx].ShowAUD == showAUD && cacheQuantum_CSI[idx].ShowNZD == showNZD && cacheQuantum_CSI[idx].AlertOverbought == alertOverbought && cacheQuantum_CSI[idx].AlertOversold == alertOversold && cacheQuantum_CSI[idx].AlertCrosses == alertCrosses && cacheQuantum_CSI[idx].AlertRearmTime == alertRearmTime && cacheQuantum_CSI[idx].AlertSoundFile == alertSoundFile && cacheQuantum_CSI[idx].EqualsInput(input))
						return cacheQuantum_CSI[idx];
			return CacheIndicator<Quantum.Quantum_CSI>(new Quantum.Quantum_CSI(){ Period = period, ShowUSD = showUSD, ShowEUR = showEUR, ShowGBP = showGBP, ShowCHF = showCHF, ShowJPY = showJPY, ShowCAD = showCAD, ShowAUD = showAUD, ShowNZD = showNZD, AlertOverbought = alertOverbought, AlertOversold = alertOversold, AlertCrosses = alertCrosses, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_CSI);
		}

		public Quantum.Quantum_CurrencyArray Quantum_CurrencyArray(ISeries<double> input, int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnOverbought, bool alertOnOversold, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_CurrencyArray != null)
				for (int idx = 0; idx < cacheQuantum_CurrencyArray.Length; idx++)
					if (cacheQuantum_CurrencyArray[idx].LookBack == lookBack && cacheQuantum_CurrencyArray[idx].OBOSPeriod == oBOSPeriod && cacheQuantum_CurrencyArray[idx].BookmarkedCurrencyPairs == bookmarkedCurrencyPairs && cacheQuantum_CurrencyArray[idx].CellSize == cellSize && cacheQuantum_CurrencyArray[idx].FontSize == fontSize && cacheQuantum_CurrencyArray[idx].AlertOnOverbought == alertOnOverbought && cacheQuantum_CurrencyArray[idx].AlertOnOversold == alertOnOversold && cacheQuantum_CurrencyArray[idx].AlertRearmTime == alertRearmTime && cacheQuantum_CurrencyArray[idx].AlertSoundFile == alertSoundFile && cacheQuantum_CurrencyArray[idx].EqualsInput(input))
						return cacheQuantum_CurrencyArray[idx];
			return CacheIndicator<Quantum.Quantum_CurrencyArray>(new Quantum.Quantum_CurrencyArray(){ LookBack = lookBack, OBOSPeriod = oBOSPeriod, BookmarkedCurrencyPairs = bookmarkedCurrencyPairs, CellSize = cellSize, FontSize = fontSize, AlertOnOverbought = alertOnOverbought, AlertOnOversold = alertOnOversold, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_CurrencyArray);
		}

		public Quantum.Quantum_CurrencyHeatmap Quantum_CurrencyHeatmap(ISeries<double> input, int lookBack, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_CurrencyHeatmap != null)
				for (int idx = 0; idx < cacheQuantum_CurrencyHeatmap.Length; idx++)
					if (cacheQuantum_CurrencyHeatmap[idx].LookBack == lookBack && cacheQuantum_CurrencyHeatmap[idx].BookmarkedCurrencyPairs == bookmarkedCurrencyPairs && cacheQuantum_CurrencyHeatmap[idx].CellSize == cellSize && cacheQuantum_CurrencyHeatmap[idx].FontSize == fontSize && cacheQuantum_CurrencyHeatmap[idx].AlertOnStrongestPair == alertOnStrongestPair && cacheQuantum_CurrencyHeatmap[idx].AlertOnWeakestPair == alertOnWeakestPair && cacheQuantum_CurrencyHeatmap[idx].AlertRearmTime == alertRearmTime && cacheQuantum_CurrencyHeatmap[idx].AlertSoundFile == alertSoundFile && cacheQuantum_CurrencyHeatmap[idx].EqualsInput(input))
						return cacheQuantum_CurrencyHeatmap[idx];
			return CacheIndicator<Quantum.Quantum_CurrencyHeatmap>(new Quantum.Quantum_CurrencyHeatmap(){ LookBack = lookBack, BookmarkedCurrencyPairs = bookmarkedCurrencyPairs, CellSize = cellSize, FontSize = fontSize, AlertOnStrongestPair = alertOnStrongestPair, AlertOnWeakestPair = alertOnWeakestPair, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_CurrencyHeatmap);
		}

		public Quantum.Quantum_CurrencyMatrix Quantum_CurrencyMatrix(ISeries<double> input, int lookBack, bool classicColors, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_CurrencyMatrix != null)
				for (int idx = 0; idx < cacheQuantum_CurrencyMatrix.Length; idx++)
					if (cacheQuantum_CurrencyMatrix[idx].LookBack == lookBack && cacheQuantum_CurrencyMatrix[idx].ClassicColors == classicColors && cacheQuantum_CurrencyMatrix[idx].BookmarkedCurrencyPairs == bookmarkedCurrencyPairs && cacheQuantum_CurrencyMatrix[idx].CellSize == cellSize && cacheQuantum_CurrencyMatrix[idx].FontSize == fontSize && cacheQuantum_CurrencyMatrix[idx].AlertOnStrongestPair == alertOnStrongestPair && cacheQuantum_CurrencyMatrix[idx].AlertOnWeakestPair == alertOnWeakestPair && cacheQuantum_CurrencyMatrix[idx].AlertRearmTime == alertRearmTime && cacheQuantum_CurrencyMatrix[idx].AlertSoundFile == alertSoundFile && cacheQuantum_CurrencyMatrix[idx].EqualsInput(input))
						return cacheQuantum_CurrencyMatrix[idx];
			return CacheIndicator<Quantum.Quantum_CurrencyMatrix>(new Quantum.Quantum_CurrencyMatrix(){ LookBack = lookBack, ClassicColors = classicColors, BookmarkedCurrencyPairs = bookmarkedCurrencyPairs, CellSize = cellSize, FontSize = fontSize, AlertOnStrongestPair = alertOnStrongestPair, AlertOnWeakestPair = alertOnWeakestPair, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_CurrencyMatrix);
		}

		public Quantum.Quantum_DynamicAccumulationAndDistribution Quantum_DynamicAccumulationAndDistribution(ISeries<double> input, int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_DynamicAccumulationAndDistribution != null)
				for (int idx = 0; idx < cacheQuantum_DynamicAccumulationAndDistribution.Length; idx++)
					if (cacheQuantum_DynamicAccumulationAndDistribution[idx].Period == period && cacheQuantum_DynamicAccumulationAndDistribution[idx].Offset == offset && cacheQuantum_DynamicAccumulationAndDistribution[idx].LabelPosition == labelPosition && cacheQuantum_DynamicAccumulationAndDistribution[idx].ClusterFactor == clusterFactor && cacheQuantum_DynamicAccumulationAndDistribution[idx].LineStyle == lineStyle && cacheQuantum_DynamicAccumulationAndDistribution[idx].AlertCrosses == alertCrosses && cacheQuantum_DynamicAccumulationAndDistribution[idx].AlertRearmTime == alertRearmTime && cacheQuantum_DynamicAccumulationAndDistribution[idx].AlertSoundFile == alertSoundFile && cacheQuantum_DynamicAccumulationAndDistribution[idx].EqualsInput(input))
						return cacheQuantum_DynamicAccumulationAndDistribution[idx];
			return CacheIndicator<Quantum.Quantum_DynamicAccumulationAndDistribution>(new Quantum.Quantum_DynamicAccumulationAndDistribution(){ Period = period, Offset = offset, LabelPosition = labelPosition, ClusterFactor = clusterFactor, LineStyle = lineStyle, AlertCrosses = alertCrosses, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_DynamicAccumulationAndDistribution);
		}

		public Quantum.Quantum_DynamicPricePivots Quantum_DynamicPricePivots(ISeries<double> input, int offset, bool alertIsolatedHigh, bool alertIsolatedLow, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_DynamicPricePivots != null)
				for (int idx = 0; idx < cacheQuantum_DynamicPricePivots.Length; idx++)
					if (cacheQuantum_DynamicPricePivots[idx].Offset == offset && cacheQuantum_DynamicPricePivots[idx].AlertIsolatedHigh == alertIsolatedHigh && cacheQuantum_DynamicPricePivots[idx].AlertIsolatedLow == alertIsolatedLow && cacheQuantum_DynamicPricePivots[idx].AlertRearmTime == alertRearmTime && cacheQuantum_DynamicPricePivots[idx].AlertSoundFile == alertSoundFile && cacheQuantum_DynamicPricePivots[idx].EqualsInput(input))
						return cacheQuantum_DynamicPricePivots[idx];
			return CacheIndicator<Quantum.Quantum_DynamicPricePivots>(new Quantum.Quantum_DynamicPricePivots(){ Offset = offset, AlertIsolatedHigh = alertIsolatedHigh, AlertIsolatedLow = alertIsolatedLow, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_DynamicPricePivots);
		}

		public Quantum.Quantum_DynamicVolatility Quantum_DynamicVolatility(ISeries<double> input, int offset, int sensitivity, bool alertVolatility, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_DynamicVolatility != null)
				for (int idx = 0; idx < cacheQuantum_DynamicVolatility.Length; idx++)
					if (cacheQuantum_DynamicVolatility[idx].Offset == offset && cacheQuantum_DynamicVolatility[idx].Sensitivity == sensitivity && cacheQuantum_DynamicVolatility[idx].AlertVolatility == alertVolatility && cacheQuantum_DynamicVolatility[idx].AlertRearmTime == alertRearmTime && cacheQuantum_DynamicVolatility[idx].AlertSoundFile == alertSoundFile && cacheQuantum_DynamicVolatility[idx].EqualsInput(input))
						return cacheQuantum_DynamicVolatility[idx];
			return CacheIndicator<Quantum.Quantum_DynamicVolatility>(new Quantum.Quantum_DynamicVolatility(){ Offset = offset, Sensitivity = sensitivity, AlertVolatility = alertVolatility, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_DynamicVolatility);
		}

		public Quantum.Quantum_EURX Quantum_EURX(ISeries<double> input, int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_EURX != null)
				for (int idx = 0; idx < cacheQuantum_EURX.Length; idx++)
					if (cacheQuantum_EURX[idx].LookBack == lookBack && cacheQuantum_EURX[idx].MA1Period == mA1Period && cacheQuantum_EURX[idx].MA2Period == mA2Period && cacheQuantum_EURX[idx].PriceType == priceType && cacheQuantum_EURX[idx].AlertOnMACross == alertOnMACross && cacheQuantum_EURX[idx].AlertRearmTime == alertRearmTime && cacheQuantum_EURX[idx].AlertSoundFile == alertSoundFile && cacheQuantum_EURX[idx].EqualsInput(input))
						return cacheQuantum_EURX[idx];
			return CacheIndicator<Quantum.Quantum_EURX>(new Quantum.Quantum_EURX(){ LookBack = lookBack, MA1Period = mA1Period, MA2Period = mA2Period, PriceType = priceType, AlertOnMACross = alertOnMACross, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_EURX);
		}

		public Quantum.Quantum_GBPX Quantum_GBPX(ISeries<double> input, int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_GBPX != null)
				for (int idx = 0; idx < cacheQuantum_GBPX.Length; idx++)
					if (cacheQuantum_GBPX[idx].LookBack == lookBack && cacheQuantum_GBPX[idx].MA1Period == mA1Period && cacheQuantum_GBPX[idx].MA2Period == mA2Period && cacheQuantum_GBPX[idx].PriceType == priceType && cacheQuantum_GBPX[idx].AlertOnMACross == alertOnMACross && cacheQuantum_GBPX[idx].AlertRearmTime == alertRearmTime && cacheQuantum_GBPX[idx].AlertSoundFile == alertSoundFile && cacheQuantum_GBPX[idx].EqualsInput(input))
						return cacheQuantum_GBPX[idx];
			return CacheIndicator<Quantum.Quantum_GBPX>(new Quantum.Quantum_GBPX(){ LookBack = lookBack, MA1Period = mA1Period, MA2Period = mA2Period, PriceType = priceType, AlertOnMACross = alertOnMACross, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_GBPX);
		}

		public Quantum.Quantum_JPYX Quantum_JPYX(ISeries<double> input, int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_JPYX != null)
				for (int idx = 0; idx < cacheQuantum_JPYX.Length; idx++)
					if (cacheQuantum_JPYX[idx].LookBack == lookBack && cacheQuantum_JPYX[idx].MA1Period == mA1Period && cacheQuantum_JPYX[idx].MA2Period == mA2Period && cacheQuantum_JPYX[idx].PriceType == priceType && cacheQuantum_JPYX[idx].AlertOnMACross == alertOnMACross && cacheQuantum_JPYX[idx].AlertRearmTime == alertRearmTime && cacheQuantum_JPYX[idx].AlertSoundFile == alertSoundFile && cacheQuantum_JPYX[idx].EqualsInput(input))
						return cacheQuantum_JPYX[idx];
			return CacheIndicator<Quantum.Quantum_JPYX>(new Quantum.Quantum_JPYX(){ LookBack = lookBack, MA1Period = mA1Period, MA2Period = mA2Period, PriceType = priceType, AlertOnMACross = alertOnMACross, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_JPYX);
		}

		public Quantum.Quantum_LiveCamarillaLevels Quantum_LiveCamarillaLevels(ISeries<double> input, bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor, bool alertAnalysisUpdate, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_LiveCamarillaLevels != null)
				for (int idx = 0; idx < cacheQuantum_LiveCamarillaLevels.Length; idx++)
					if (cacheQuantum_LiveCamarillaLevels[idx].Analyze == analyze && cacheQuantum_LiveCamarillaLevels[idx].ShowLabels == showLabels && cacheQuantum_LiveCamarillaLevels[idx].LineThickness == lineThickness && cacheQuantum_LiveCamarillaLevels[idx].LabelHorizontalOffset == labelHorizontalOffset && cacheQuantum_LiveCamarillaLevels[idx].LabelVerticalOffset == labelVerticalOffset && cacheQuantum_LiveCamarillaLevels[idx].LabelFontSize == labelFontSize && cacheQuantum_LiveCamarillaLevels[idx].AnalysisBoxFontSize == analysisBoxFontSize && cacheQuantum_LiveCamarillaLevels[idx].S1R1Color == s1R1Color && cacheQuantum_LiveCamarillaLevels[idx].S2R2Color == s2R2Color && cacheQuantum_LiveCamarillaLevels[idx].S3R3Color == s3R3Color && cacheQuantum_LiveCamarillaLevels[idx].S4R4Color == s4R4Color && cacheQuantum_LiveCamarillaLevels[idx].S5R5Color == s5R5Color && cacheQuantum_LiveCamarillaLevels[idx].S6R6Color == s6R6Color && cacheQuantum_LiveCamarillaLevels[idx].BoxColor == boxColor && cacheQuantum_LiveCamarillaLevels[idx].BoxFontColor == boxFontColor && cacheQuantum_LiveCamarillaLevels[idx].AlertAnalysisUpdate == alertAnalysisUpdate && cacheQuantum_LiveCamarillaLevels[idx].AlertCrosses == alertCrosses && cacheQuantum_LiveCamarillaLevels[idx].AlertRearmTime == alertRearmTime && cacheQuantum_LiveCamarillaLevels[idx].AlertSoundFile == alertSoundFile && cacheQuantum_LiveCamarillaLevels[idx].EqualsInput(input))
						return cacheQuantum_LiveCamarillaLevels[idx];
			return CacheIndicator<Quantum.Quantum_LiveCamarillaLevels>(new Quantum.Quantum_LiveCamarillaLevels(){ Analyze = analyze, ShowLabels = showLabels, LineThickness = lineThickness, LabelHorizontalOffset = labelHorizontalOffset, LabelVerticalOffset = labelVerticalOffset, LabelFontSize = labelFontSize, AnalysisBoxFontSize = analysisBoxFontSize, S1R1Color = s1R1Color, S2R2Color = s2R2Color, S3R3Color = s3R3Color, S4R4Color = s4R4Color, S5R5Color = s5R5Color, S6R6Color = s6R6Color, BoxColor = boxColor, BoxFontColor = boxFontColor, AlertAnalysisUpdate = alertAnalysisUpdate, AlertCrosses = alertCrosses, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_LiveCamarillaLevels);
		}

		public Quantum.Quantum_MarketStrengthIndicator Quantum_MarketStrengthIndicator(ISeries<double> input, int lookBack, bool enableInstrument1, bool enableInstrument2, bool enableInstrument3, bool enableInstrument4, bool enableInstrument5, bool showInstrument0, bool showInstrument1, bool showInstrument2, bool showInstrument3, bool showInstrument4, bool showInstrument5, bool alertOverbought, bool alertOversold, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			if (cacheQuantum_MarketStrengthIndicator != null)
				for (int idx = 0; idx < cacheQuantum_MarketStrengthIndicator.Length; idx++)
					if (cacheQuantum_MarketStrengthIndicator[idx].LookBack == lookBack && cacheQuantum_MarketStrengthIndicator[idx].EnableInstrument1 == enableInstrument1 && cacheQuantum_MarketStrengthIndicator[idx].EnableInstrument2 == enableInstrument2 && cacheQuantum_MarketStrengthIndicator[idx].EnableInstrument3 == enableInstrument3 && cacheQuantum_MarketStrengthIndicator[idx].EnableInstrument4 == enableInstrument4 && cacheQuantum_MarketStrengthIndicator[idx].EnableInstrument5 == enableInstrument5 && cacheQuantum_MarketStrengthIndicator[idx].ShowInstrument0 == showInstrument0 && cacheQuantum_MarketStrengthIndicator[idx].ShowInstrument1 == showInstrument1 && cacheQuantum_MarketStrengthIndicator[idx].ShowInstrument2 == showInstrument2 && cacheQuantum_MarketStrengthIndicator[idx].ShowInstrument3 == showInstrument3 && cacheQuantum_MarketStrengthIndicator[idx].ShowInstrument4 == showInstrument4 && cacheQuantum_MarketStrengthIndicator[idx].ShowInstrument5 == showInstrument5 && cacheQuantum_MarketStrengthIndicator[idx].AlertOverbought == alertOverbought && cacheQuantum_MarketStrengthIndicator[idx].AlertOversold == alertOversold && cacheQuantum_MarketStrengthIndicator[idx].AlertRearmTime == alertRearmTime && cacheQuantum_MarketStrengthIndicator[idx].AlertSoundFile == alertSoundFile && cacheQuantum_MarketStrengthIndicator[idx].AlertConfirmedOnly == alertConfirmedOnly && cacheQuantum_MarketStrengthIndicator[idx].EqualsInput(input))
						return cacheQuantum_MarketStrengthIndicator[idx];
			return CacheIndicator<Quantum.Quantum_MarketStrengthIndicator>(new Quantum.Quantum_MarketStrengthIndicator(){ LookBack = lookBack, EnableInstrument1 = enableInstrument1, EnableInstrument2 = enableInstrument2, EnableInstrument3 = enableInstrument3, EnableInstrument4 = enableInstrument4, EnableInstrument5 = enableInstrument5, ShowInstrument0 = showInstrument0, ShowInstrument1 = showInstrument1, ShowInstrument2 = showInstrument2, ShowInstrument3 = showInstrument3, ShowInstrument4 = showInstrument4, ShowInstrument5 = showInstrument5, AlertOverbought = alertOverbought, AlertOversold = alertOversold, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile, AlertConfirmedOnly = alertConfirmedOnly }, input, ref cacheQuantum_MarketStrengthIndicator);
		}

		public Quantum.Quantum_RenkoOptimiser Quantum_RenkoOptimiser(ISeries<double> input, int aTRPeriod, int buttonSize, bool alertOnNewRenko, bool alertOnBullishTrendShift, bool alertOnBearishTrendShift, bool alertOnTrendShift, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_RenkoOptimiser != null)
				for (int idx = 0; idx < cacheQuantum_RenkoOptimiser.Length; idx++)
					if (cacheQuantum_RenkoOptimiser[idx].ATRPeriod == aTRPeriod && cacheQuantum_RenkoOptimiser[idx].ButtonSize == buttonSize && cacheQuantum_RenkoOptimiser[idx].AlertOnNewRenko == alertOnNewRenko && cacheQuantum_RenkoOptimiser[idx].AlertOnBullishTrendShift == alertOnBullishTrendShift && cacheQuantum_RenkoOptimiser[idx].AlertOnBearishTrendShift == alertOnBearishTrendShift && cacheQuantum_RenkoOptimiser[idx].AlertOnTrendShift == alertOnTrendShift && cacheQuantum_RenkoOptimiser[idx].AlertRearmTime == alertRearmTime && cacheQuantum_RenkoOptimiser[idx].AlertSoundFile == alertSoundFile && cacheQuantum_RenkoOptimiser[idx].EqualsInput(input))
						return cacheQuantum_RenkoOptimiser[idx];
			return CacheIndicator<Quantum.Quantum_RenkoOptimiser>(new Quantum.Quantum_RenkoOptimiser(){ ATRPeriod = aTRPeriod, ButtonSize = buttonSize, AlertOnNewRenko = alertOnNewRenko, AlertOnBullishTrendShift = alertOnBullishTrendShift, AlertOnBearishTrendShift = alertOnBearishTrendShift, AlertOnTrendShift = alertOnTrendShift, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_RenkoOptimiser);
		}

		public Quantum.Quantum_TickSpeedometer Quantum_TickSpeedometer(ISeries<double> input, int period, bool dockRight, bool dockDown, bool alertOnCurrentSpeedChange, bool alertOnAverageSpeedChange, bool alertOnFibTickChange, int alertRearmTime, string alertSoundFile, bool alertCurSpeedOnFormingCandle)
		{
			if (cacheQuantum_TickSpeedometer != null)
				for (int idx = 0; idx < cacheQuantum_TickSpeedometer.Length; idx++)
					if (cacheQuantum_TickSpeedometer[idx].Period == period && cacheQuantum_TickSpeedometer[idx].DockRight == dockRight && cacheQuantum_TickSpeedometer[idx].DockDown == dockDown && cacheQuantum_TickSpeedometer[idx].AlertOnCurrentSpeedChange == alertOnCurrentSpeedChange && cacheQuantum_TickSpeedometer[idx].AlertOnAverageSpeedChange == alertOnAverageSpeedChange && cacheQuantum_TickSpeedometer[idx].AlertOnFibTickChange == alertOnFibTickChange && cacheQuantum_TickSpeedometer[idx].AlertRearmTime == alertRearmTime && cacheQuantum_TickSpeedometer[idx].AlertSoundFile == alertSoundFile && cacheQuantum_TickSpeedometer[idx].AlertCurSpeedOnFormingCandle == alertCurSpeedOnFormingCandle && cacheQuantum_TickSpeedometer[idx].EqualsInput(input))
						return cacheQuantum_TickSpeedometer[idx];
			return CacheIndicator<Quantum.Quantum_TickSpeedometer>(new Quantum.Quantum_TickSpeedometer(){ Period = period, DockRight = dockRight, DockDown = dockDown, AlertOnCurrentSpeedChange = alertOnCurrentSpeedChange, AlertOnAverageSpeedChange = alertOnAverageSpeedChange, AlertOnFibTickChange = alertOnFibTickChange, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile, AlertCurSpeedOnFormingCandle = alertCurSpeedOnFormingCandle }, input, ref cacheQuantum_TickSpeedometer);
		}

		public Quantum.Quantum_TrendMonitor Quantum_TrendMonitor(ISeries<double> input, int tolerance, bool showTrendLine, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			if (cacheQuantum_TrendMonitor != null)
				for (int idx = 0; idx < cacheQuantum_TrendMonitor.Length; idx++)
					if (cacheQuantum_TrendMonitor[idx].Tolerance == tolerance && cacheQuantum_TrendMonitor[idx].ShowTrendLine == showTrendLine && cacheQuantum_TrendMonitor[idx].AlertTrendChange == alertTrendChange && cacheQuantum_TrendMonitor[idx].AlertRearmTime == alertRearmTime && cacheQuantum_TrendMonitor[idx].AlertSoundFile == alertSoundFile && cacheQuantum_TrendMonitor[idx].AlertOnFormingCandle == alertOnFormingCandle && cacheQuantum_TrendMonitor[idx].EqualsInput(input))
						return cacheQuantum_TrendMonitor[idx];
			return CacheIndicator<Quantum.Quantum_TrendMonitor>(new Quantum.Quantum_TrendMonitor(){ Tolerance = tolerance, ShowTrendLine = showTrendLine, AlertTrendChange = alertTrendChange, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile, AlertOnFormingCandle = alertOnFormingCandle }, input, ref cacheQuantum_TrendMonitor);
		}

		public Quantum.Quantum_Trends Quantum_Trends(ISeries<double> input, int sensitivityToCongestion, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			if (cacheQuantum_Trends != null)
				for (int idx = 0; idx < cacheQuantum_Trends.Length; idx++)
					if (cacheQuantum_Trends[idx].SensitivityToCongestion == sensitivityToCongestion && cacheQuantum_Trends[idx].AlertTrendChange == alertTrendChange && cacheQuantum_Trends[idx].AlertRearmTime == alertRearmTime && cacheQuantum_Trends[idx].AlertSoundFile == alertSoundFile && cacheQuantum_Trends[idx].AlertOnFormingCandle == alertOnFormingCandle && cacheQuantum_Trends[idx].EqualsInput(input))
						return cacheQuantum_Trends[idx];
			return CacheIndicator<Quantum.Quantum_Trends>(new Quantum.Quantum_Trends(){ SensitivityToCongestion = sensitivityToCongestion, AlertTrendChange = alertTrendChange, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile, AlertOnFormingCandle = alertOnFormingCandle }, input, ref cacheQuantum_Trends);
		}

		public Quantum.Quantum_USDX Quantum_USDX(ISeries<double> input, int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_USDX != null)
				for (int idx = 0; idx < cacheQuantum_USDX.Length; idx++)
					if (cacheQuantum_USDX[idx].LookBack == lookBack && cacheQuantum_USDX[idx].MA1Period == mA1Period && cacheQuantum_USDX[idx].MA2Period == mA2Period && cacheQuantum_USDX[idx].PriceType == priceType && cacheQuantum_USDX[idx].AlertOnMACross == alertOnMACross && cacheQuantum_USDX[idx].AlertRearmTime == alertRearmTime && cacheQuantum_USDX[idx].AlertSoundFile == alertSoundFile && cacheQuantum_USDX[idx].EqualsInput(input))
						return cacheQuantum_USDX[idx];
			return CacheIndicator<Quantum.Quantum_USDX>(new Quantum.Quantum_USDX(){ LookBack = lookBack, MA1Period = mA1Period, MA2Period = mA2Period, PriceType = priceType, AlertOnMACross = alertOnMACross, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_USDX);
		}

		public Quantum.Quantum_Volume Quantum_Volume(ISeries<double> input, bool displayHighVolumeLine, bool displayLowVolumeLine, bool alertHighVolume, bool alertLowVolume, bool alertAveVolume, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_Volume != null)
				for (int idx = 0; idx < cacheQuantum_Volume.Length; idx++)
					if (cacheQuantum_Volume[idx].DisplayHighVolumeLine == displayHighVolumeLine && cacheQuantum_Volume[idx].DisplayLowVolumeLine == displayLowVolumeLine && cacheQuantum_Volume[idx].AlertHighVolume == alertHighVolume && cacheQuantum_Volume[idx].AlertLowVolume == alertLowVolume && cacheQuantum_Volume[idx].AlertAveVolume == alertAveVolume && cacheQuantum_Volume[idx].AlertRearmTime == alertRearmTime && cacheQuantum_Volume[idx].AlertSoundFile == alertSoundFile && cacheQuantum_Volume[idx].EqualsInput(input))
						return cacheQuantum_Volume[idx];
			return CacheIndicator<Quantum.Quantum_Volume>(new Quantum.Quantum_Volume(){ DisplayHighVolumeLine = displayHighVolumeLine, DisplayLowVolumeLine = displayLowVolumeLine, AlertHighVolume = alertHighVolume, AlertLowVolume = alertLowVolume, AlertAveVolume = alertAveVolume, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_Volume);
		}

		public Quantum.Quantum_VPOC Quantum_VPOC(ISeries<double> input, bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, bool displayLeft, int lookBackPeriod, int regionCount, VPOCSRLineCount sRLineCount, bool alertVPOCCross, bool alertHVNLVNCross, int alertRearmTime, string alertSoundFile)
		{
			if (cacheQuantum_VPOC != null)
				for (int idx = 0; idx < cacheQuantum_VPOC.Length; idx++)
					if (cacheQuantum_VPOC[idx].ShowSupportResistance == showSupportResistance && cacheQuantum_VPOC[idx].ShowVolumePointOfControl == showVolumePointOfControl && cacheQuantum_VPOC[idx].ShowVolumeProfile == showVolumeProfile && cacheQuantum_VPOC[idx].DisplayLeft == displayLeft && cacheQuantum_VPOC[idx].LookBackPeriod == lookBackPeriod && cacheQuantum_VPOC[idx].RegionCount == regionCount && cacheQuantum_VPOC[idx].SRLineCount == sRLineCount && cacheQuantum_VPOC[idx].AlertVPOCCross == alertVPOCCross && cacheQuantum_VPOC[idx].AlertHVNLVNCross == alertHVNLVNCross && cacheQuantum_VPOC[idx].AlertRearmTime == alertRearmTime && cacheQuantum_VPOC[idx].AlertSoundFile == alertSoundFile && cacheQuantum_VPOC[idx].EqualsInput(input))
						return cacheQuantum_VPOC[idx];
			return CacheIndicator<Quantum.Quantum_VPOC>(new Quantum.Quantum_VPOC(){ ShowSupportResistance = showSupportResistance, ShowVolumePointOfControl = showVolumePointOfControl, ShowVolumeProfile = showVolumeProfile, DisplayLeft = displayLeft, LookBackPeriod = lookBackPeriod, RegionCount = regionCount, SRLineCount = sRLineCount, AlertVPOCCross = alertVPOCCross, AlertHVNLVNCross = alertHVNLVNCross, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile }, input, ref cacheQuantum_VPOC);
		}

		public Quantum.Quantum_VRSI Quantum_VRSI(ISeries<double> input, int period, bool alertSentiment, bool alertZeroCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			if (cacheQuantum_VRSI != null)
				for (int idx = 0; idx < cacheQuantum_VRSI.Length; idx++)
					if (cacheQuantum_VRSI[idx].Period == period && cacheQuantum_VRSI[idx].AlertSentiment == alertSentiment && cacheQuantum_VRSI[idx].AlertZeroCrosses == alertZeroCrosses && cacheQuantum_VRSI[idx].AlertRearmTime == alertRearmTime && cacheQuantum_VRSI[idx].AlertSoundFile == alertSoundFile && cacheQuantum_VRSI[idx].AlertConfirmedOnly == alertConfirmedOnly && cacheQuantum_VRSI[idx].EqualsInput(input))
						return cacheQuantum_VRSI[idx];
			return CacheIndicator<Quantum.Quantum_VRSI>(new Quantum.Quantum_VRSI(){ Period = period, AlertSentiment = alertSentiment, AlertZeroCrosses = alertZeroCrosses, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile, AlertConfirmedOnly = alertConfirmedOnly }, input, ref cacheQuantum_VRSI);
		}

		public Quantum.Quantum_VWAPPro Quantum_VWAPPro(ISeries<double> input, QTWAPTypes wAPType, int wAPOpacity, bool showULB, bool fillRegions, double multiplier, string wAPID, int mVWAPPeriod, int mVWAPStdDevPeriod, int tWAPPeriod, int tWAPStdDevPeriod, QTWAPPeriod wAPPeriod, bool alertCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			if (cacheQuantum_VWAPPro != null)
				for (int idx = 0; idx < cacheQuantum_VWAPPro.Length; idx++)
					if (cacheQuantum_VWAPPro[idx].WAPType == wAPType && cacheQuantum_VWAPPro[idx].WAPOpacity == wAPOpacity && cacheQuantum_VWAPPro[idx].ShowULB == showULB && cacheQuantum_VWAPPro[idx].FillRegions == fillRegions && cacheQuantum_VWAPPro[idx].Multiplier == multiplier && cacheQuantum_VWAPPro[idx].WAPID == wAPID && cacheQuantum_VWAPPro[idx].MVWAPPeriod == mVWAPPeriod && cacheQuantum_VWAPPro[idx].MVWAPStdDevPeriod == mVWAPStdDevPeriod && cacheQuantum_VWAPPro[idx].TWAPPeriod == tWAPPeriod && cacheQuantum_VWAPPro[idx].TWAPStdDevPeriod == tWAPStdDevPeriod && cacheQuantum_VWAPPro[idx].WAPPeriod == wAPPeriod && cacheQuantum_VWAPPro[idx].AlertCrosses == alertCrosses && cacheQuantum_VWAPPro[idx].AlertRearmTime == alertRearmTime && cacheQuantum_VWAPPro[idx].AlertSoundFile == alertSoundFile && cacheQuantum_VWAPPro[idx].AlertConfirmedOnly == alertConfirmedOnly && cacheQuantum_VWAPPro[idx].EqualsInput(input))
						return cacheQuantum_VWAPPro[idx];
			return CacheIndicator<Quantum.Quantum_VWAPPro>(new Quantum.Quantum_VWAPPro(){ WAPType = wAPType, WAPOpacity = wAPOpacity, ShowULB = showULB, FillRegions = fillRegions, Multiplier = multiplier, WAPID = wAPID, MVWAPPeriod = mVWAPPeriod, MVWAPStdDevPeriod = mVWAPStdDevPeriod, TWAPPeriod = tWAPPeriod, TWAPStdDevPeriod = tWAPStdDevPeriod, WAPPeriod = wAPPeriod, AlertCrosses = alertCrosses, AlertRearmTime = alertRearmTime, AlertSoundFile = alertSoundFile, AlertConfirmedOnly = alertConfirmedOnly }, input, ref cacheQuantum_VWAPPro);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.Quantum.Quantum_CSI Quantum_CSI(int period, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool alertOverbought, bool alertOversold, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CSI(Input, period, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, alertOverbought, alertOversold, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyArray Quantum_CurrencyArray(int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnOverbought, bool alertOnOversold, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyArray(Input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnOverbought, alertOnOversold, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyHeatmap Quantum_CurrencyHeatmap(int lookBack, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyHeatmap(Input, lookBack, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyMatrix Quantum_CurrencyMatrix(int lookBack, bool classicColors, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyMatrix(Input, lookBack, classicColors, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicAccumulationAndDistribution Quantum_DynamicAccumulationAndDistribution(int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicAccumulationAndDistribution(Input, period, offset, labelPosition, clusterFactor, lineStyle, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicPricePivots Quantum_DynamicPricePivots(int offset, bool alertIsolatedHigh, bool alertIsolatedLow, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicPricePivots(Input, offset, alertIsolatedHigh, alertIsolatedLow, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicVolatility Quantum_DynamicVolatility(int offset, int sensitivity, bool alertVolatility, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicVolatility(Input, offset, sensitivity, alertVolatility, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_EURX Quantum_EURX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_EURX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_GBPX Quantum_GBPX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_GBPX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_JPYX Quantum_JPYX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_JPYX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_LiveCamarillaLevels Quantum_LiveCamarillaLevels(bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor, bool alertAnalysisUpdate, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_LiveCamarillaLevels(Input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor, alertAnalysisUpdate, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_MarketStrengthIndicator Quantum_MarketStrengthIndicator(int lookBack, bool enableInstrument1, bool enableInstrument2, bool enableInstrument3, bool enableInstrument4, bool enableInstrument5, bool showInstrument0, bool showInstrument1, bool showInstrument2, bool showInstrument3, bool showInstrument4, bool showInstrument5, bool alertOverbought, bool alertOversold, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_MarketStrengthIndicator(Input, lookBack, enableInstrument1, enableInstrument2, enableInstrument3, enableInstrument4, enableInstrument5, showInstrument0, showInstrument1, showInstrument2, showInstrument3, showInstrument4, showInstrument5, alertOverbought, alertOversold, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Indicators.Quantum.Quantum_RenkoOptimiser Quantum_RenkoOptimiser(int aTRPeriod, int buttonSize, bool alertOnNewRenko, bool alertOnBullishTrendShift, bool alertOnBearishTrendShift, bool alertOnTrendShift, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_RenkoOptimiser(Input, aTRPeriod, buttonSize, alertOnNewRenko, alertOnBullishTrendShift, alertOnBearishTrendShift, alertOnTrendShift, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_TickSpeedometer Quantum_TickSpeedometer(int period, bool dockRight, bool dockDown, bool alertOnCurrentSpeedChange, bool alertOnAverageSpeedChange, bool alertOnFibTickChange, int alertRearmTime, string alertSoundFile, bool alertCurSpeedOnFormingCandle)
		{
			return indicator.Quantum_TickSpeedometer(Input, period, dockRight, dockDown, alertOnCurrentSpeedChange, alertOnAverageSpeedChange, alertOnFibTickChange, alertRearmTime, alertSoundFile, alertCurSpeedOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_TrendMonitor Quantum_TrendMonitor(int tolerance, bool showTrendLine, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return indicator.Quantum_TrendMonitor(Input, tolerance, showTrendLine, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_Trends Quantum_Trends(int sensitivityToCongestion, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return indicator.Quantum_Trends(Input, sensitivityToCongestion, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_USDX Quantum_USDX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_USDX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_Volume Quantum_Volume(bool displayHighVolumeLine, bool displayLowVolumeLine, bool alertHighVolume, bool alertLowVolume, bool alertAveVolume, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_Volume(Input, displayHighVolumeLine, displayLowVolumeLine, alertHighVolume, alertLowVolume, alertAveVolume, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_VPOC Quantum_VPOC(bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, bool displayLeft, int lookBackPeriod, int regionCount, VPOCSRLineCount sRLineCount, bool alertVPOCCross, bool alertHVNLVNCross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_VPOC(Input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, displayLeft, lookBackPeriod, regionCount, sRLineCount, alertVPOCCross, alertHVNLVNCross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_VRSI Quantum_VRSI(int period, bool alertSentiment, bool alertZeroCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_VRSI(Input, period, alertSentiment, alertZeroCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Indicators.Quantum.Quantum_VWAPPro Quantum_VWAPPro(QTWAPTypes wAPType, int wAPOpacity, bool showULB, bool fillRegions, double multiplier, string wAPID, int mVWAPPeriod, int mVWAPStdDevPeriod, int tWAPPeriod, int tWAPStdDevPeriod, QTWAPPeriod wAPPeriod, bool alertCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_VWAPPro(Input, wAPType, wAPOpacity, showULB, fillRegions, multiplier, wAPID, mVWAPPeriod, mVWAPStdDevPeriod, tWAPPeriod, tWAPStdDevPeriod, wAPPeriod, alertCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}


		
		public Indicators.Quantum.Quantum_CSI Quantum_CSI(ISeries<double> input , int period, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool alertOverbought, bool alertOversold, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CSI(input, period, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, alertOverbought, alertOversold, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyArray Quantum_CurrencyArray(ISeries<double> input , int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnOverbought, bool alertOnOversold, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyArray(input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnOverbought, alertOnOversold, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyHeatmap Quantum_CurrencyHeatmap(ISeries<double> input , int lookBack, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyHeatmap(input, lookBack, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyMatrix Quantum_CurrencyMatrix(ISeries<double> input , int lookBack, bool classicColors, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyMatrix(input, lookBack, classicColors, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicAccumulationAndDistribution Quantum_DynamicAccumulationAndDistribution(ISeries<double> input , int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicAccumulationAndDistribution(input, period, offset, labelPosition, clusterFactor, lineStyle, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicPricePivots Quantum_DynamicPricePivots(ISeries<double> input , int offset, bool alertIsolatedHigh, bool alertIsolatedLow, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicPricePivots(input, offset, alertIsolatedHigh, alertIsolatedLow, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicVolatility Quantum_DynamicVolatility(ISeries<double> input , int offset, int sensitivity, bool alertVolatility, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicVolatility(input, offset, sensitivity, alertVolatility, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_EURX Quantum_EURX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_EURX(input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_GBPX Quantum_GBPX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_GBPX(input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_JPYX Quantum_JPYX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_JPYX(input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_LiveCamarillaLevels Quantum_LiveCamarillaLevels(ISeries<double> input , bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor, bool alertAnalysisUpdate, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_LiveCamarillaLevels(input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor, alertAnalysisUpdate, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_MarketStrengthIndicator Quantum_MarketStrengthIndicator(ISeries<double> input , int lookBack, bool enableInstrument1, bool enableInstrument2, bool enableInstrument3, bool enableInstrument4, bool enableInstrument5, bool showInstrument0, bool showInstrument1, bool showInstrument2, bool showInstrument3, bool showInstrument4, bool showInstrument5, bool alertOverbought, bool alertOversold, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_MarketStrengthIndicator(input, lookBack, enableInstrument1, enableInstrument2, enableInstrument3, enableInstrument4, enableInstrument5, showInstrument0, showInstrument1, showInstrument2, showInstrument3, showInstrument4, showInstrument5, alertOverbought, alertOversold, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Indicators.Quantum.Quantum_RenkoOptimiser Quantum_RenkoOptimiser(ISeries<double> input , int aTRPeriod, int buttonSize, bool alertOnNewRenko, bool alertOnBullishTrendShift, bool alertOnBearishTrendShift, bool alertOnTrendShift, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_RenkoOptimiser(input, aTRPeriod, buttonSize, alertOnNewRenko, alertOnBullishTrendShift, alertOnBearishTrendShift, alertOnTrendShift, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_TickSpeedometer Quantum_TickSpeedometer(ISeries<double> input , int period, bool dockRight, bool dockDown, bool alertOnCurrentSpeedChange, bool alertOnAverageSpeedChange, bool alertOnFibTickChange, int alertRearmTime, string alertSoundFile, bool alertCurSpeedOnFormingCandle)
		{
			return indicator.Quantum_TickSpeedometer(input, period, dockRight, dockDown, alertOnCurrentSpeedChange, alertOnAverageSpeedChange, alertOnFibTickChange, alertRearmTime, alertSoundFile, alertCurSpeedOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_TrendMonitor Quantum_TrendMonitor(ISeries<double> input , int tolerance, bool showTrendLine, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return indicator.Quantum_TrendMonitor(input, tolerance, showTrendLine, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_Trends Quantum_Trends(ISeries<double> input , int sensitivityToCongestion, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return indicator.Quantum_Trends(input, sensitivityToCongestion, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_USDX Quantum_USDX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_USDX(input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_Volume Quantum_Volume(ISeries<double> input , bool displayHighVolumeLine, bool displayLowVolumeLine, bool alertHighVolume, bool alertLowVolume, bool alertAveVolume, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_Volume(input, displayHighVolumeLine, displayLowVolumeLine, alertHighVolume, alertLowVolume, alertAveVolume, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_VPOC Quantum_VPOC(ISeries<double> input , bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, bool displayLeft, int lookBackPeriod, int regionCount, VPOCSRLineCount sRLineCount, bool alertVPOCCross, bool alertHVNLVNCross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_VPOC(input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, displayLeft, lookBackPeriod, regionCount, sRLineCount, alertVPOCCross, alertHVNLVNCross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_VRSI Quantum_VRSI(ISeries<double> input , int period, bool alertSentiment, bool alertZeroCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_VRSI(input, period, alertSentiment, alertZeroCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Indicators.Quantum.Quantum_VWAPPro Quantum_VWAPPro(ISeries<double> input , QTWAPTypes wAPType, int wAPOpacity, bool showULB, bool fillRegions, double multiplier, string wAPID, int mVWAPPeriod, int mVWAPStdDevPeriod, int tWAPPeriod, int tWAPStdDevPeriod, QTWAPPeriod wAPPeriod, bool alertCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_VWAPPro(input, wAPType, wAPOpacity, showULB, fillRegions, multiplier, wAPID, mVWAPPeriod, mVWAPStdDevPeriod, tWAPPeriod, tWAPStdDevPeriod, wAPPeriod, alertCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.Quantum.Quantum_CSI Quantum_CSI(int period, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool alertOverbought, bool alertOversold, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CSI(Input, period, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, alertOverbought, alertOversold, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyArray Quantum_CurrencyArray(int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnOverbought, bool alertOnOversold, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyArray(Input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnOverbought, alertOnOversold, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyHeatmap Quantum_CurrencyHeatmap(int lookBack, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyHeatmap(Input, lookBack, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyMatrix Quantum_CurrencyMatrix(int lookBack, bool classicColors, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyMatrix(Input, lookBack, classicColors, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicAccumulationAndDistribution Quantum_DynamicAccumulationAndDistribution(int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicAccumulationAndDistribution(Input, period, offset, labelPosition, clusterFactor, lineStyle, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicPricePivots Quantum_DynamicPricePivots(int offset, bool alertIsolatedHigh, bool alertIsolatedLow, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicPricePivots(Input, offset, alertIsolatedHigh, alertIsolatedLow, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicVolatility Quantum_DynamicVolatility(int offset, int sensitivity, bool alertVolatility, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicVolatility(Input, offset, sensitivity, alertVolatility, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_EURX Quantum_EURX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_EURX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_GBPX Quantum_GBPX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_GBPX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_JPYX Quantum_JPYX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_JPYX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_LiveCamarillaLevels Quantum_LiveCamarillaLevels(bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor, bool alertAnalysisUpdate, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_LiveCamarillaLevels(Input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor, alertAnalysisUpdate, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_MarketStrengthIndicator Quantum_MarketStrengthIndicator(int lookBack, bool enableInstrument1, bool enableInstrument2, bool enableInstrument3, bool enableInstrument4, bool enableInstrument5, bool showInstrument0, bool showInstrument1, bool showInstrument2, bool showInstrument3, bool showInstrument4, bool showInstrument5, bool alertOverbought, bool alertOversold, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_MarketStrengthIndicator(Input, lookBack, enableInstrument1, enableInstrument2, enableInstrument3, enableInstrument4, enableInstrument5, showInstrument0, showInstrument1, showInstrument2, showInstrument3, showInstrument4, showInstrument5, alertOverbought, alertOversold, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Indicators.Quantum.Quantum_RenkoOptimiser Quantum_RenkoOptimiser(int aTRPeriod, int buttonSize, bool alertOnNewRenko, bool alertOnBullishTrendShift, bool alertOnBearishTrendShift, bool alertOnTrendShift, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_RenkoOptimiser(Input, aTRPeriod, buttonSize, alertOnNewRenko, alertOnBullishTrendShift, alertOnBearishTrendShift, alertOnTrendShift, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_TickSpeedometer Quantum_TickSpeedometer(int period, bool dockRight, bool dockDown, bool alertOnCurrentSpeedChange, bool alertOnAverageSpeedChange, bool alertOnFibTickChange, int alertRearmTime, string alertSoundFile, bool alertCurSpeedOnFormingCandle)
		{
			return indicator.Quantum_TickSpeedometer(Input, period, dockRight, dockDown, alertOnCurrentSpeedChange, alertOnAverageSpeedChange, alertOnFibTickChange, alertRearmTime, alertSoundFile, alertCurSpeedOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_TrendMonitor Quantum_TrendMonitor(int tolerance, bool showTrendLine, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return indicator.Quantum_TrendMonitor(Input, tolerance, showTrendLine, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_Trends Quantum_Trends(int sensitivityToCongestion, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return indicator.Quantum_Trends(Input, sensitivityToCongestion, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_USDX Quantum_USDX(int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_USDX(Input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_Volume Quantum_Volume(bool displayHighVolumeLine, bool displayLowVolumeLine, bool alertHighVolume, bool alertLowVolume, bool alertAveVolume, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_Volume(Input, displayHighVolumeLine, displayLowVolumeLine, alertHighVolume, alertLowVolume, alertAveVolume, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_VPOC Quantum_VPOC(bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, bool displayLeft, int lookBackPeriod, int regionCount, VPOCSRLineCount sRLineCount, bool alertVPOCCross, bool alertHVNLVNCross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_VPOC(Input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, displayLeft, lookBackPeriod, regionCount, sRLineCount, alertVPOCCross, alertHVNLVNCross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_VRSI Quantum_VRSI(int period, bool alertSentiment, bool alertZeroCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_VRSI(Input, period, alertSentiment, alertZeroCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Indicators.Quantum.Quantum_VWAPPro Quantum_VWAPPro(QTWAPTypes wAPType, int wAPOpacity, bool showULB, bool fillRegions, double multiplier, string wAPID, int mVWAPPeriod, int mVWAPStdDevPeriod, int tWAPPeriod, int tWAPStdDevPeriod, QTWAPPeriod wAPPeriod, bool alertCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_VWAPPro(Input, wAPType, wAPOpacity, showULB, fillRegions, multiplier, wAPID, mVWAPPeriod, mVWAPStdDevPeriod, tWAPPeriod, tWAPStdDevPeriod, wAPPeriod, alertCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}


		
		public Indicators.Quantum.Quantum_CSI Quantum_CSI(ISeries<double> input , int period, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool alertOverbought, bool alertOversold, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CSI(input, period, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, alertOverbought, alertOversold, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyArray Quantum_CurrencyArray(ISeries<double> input , int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnOverbought, bool alertOnOversold, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyArray(input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnOverbought, alertOnOversold, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyHeatmap Quantum_CurrencyHeatmap(ISeries<double> input , int lookBack, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyHeatmap(input, lookBack, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_CurrencyMatrix Quantum_CurrencyMatrix(ISeries<double> input , int lookBack, bool classicColors, string bookmarkedCurrencyPairs, int cellSize, int fontSize, bool alertOnStrongestPair, bool alertOnWeakestPair, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_CurrencyMatrix(input, lookBack, classicColors, bookmarkedCurrencyPairs, cellSize, fontSize, alertOnStrongestPair, alertOnWeakestPair, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicAccumulationAndDistribution Quantum_DynamicAccumulationAndDistribution(ISeries<double> input , int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicAccumulationAndDistribution(input, period, offset, labelPosition, clusterFactor, lineStyle, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicPricePivots Quantum_DynamicPricePivots(ISeries<double> input , int offset, bool alertIsolatedHigh, bool alertIsolatedLow, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicPricePivots(input, offset, alertIsolatedHigh, alertIsolatedLow, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_DynamicVolatility Quantum_DynamicVolatility(ISeries<double> input , int offset, int sensitivity, bool alertVolatility, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_DynamicVolatility(input, offset, sensitivity, alertVolatility, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_EURX Quantum_EURX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_EURX(input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_GBPX Quantum_GBPX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_GBPX(input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_JPYX Quantum_JPYX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_JPYX(input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_LiveCamarillaLevels Quantum_LiveCamarillaLevels(ISeries<double> input , bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor, bool alertAnalysisUpdate, bool alertCrosses, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_LiveCamarillaLevels(input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor, alertAnalysisUpdate, alertCrosses, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_MarketStrengthIndicator Quantum_MarketStrengthIndicator(ISeries<double> input , int lookBack, bool enableInstrument1, bool enableInstrument2, bool enableInstrument3, bool enableInstrument4, bool enableInstrument5, bool showInstrument0, bool showInstrument1, bool showInstrument2, bool showInstrument3, bool showInstrument4, bool showInstrument5, bool alertOverbought, bool alertOversold, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_MarketStrengthIndicator(input, lookBack, enableInstrument1, enableInstrument2, enableInstrument3, enableInstrument4, enableInstrument5, showInstrument0, showInstrument1, showInstrument2, showInstrument3, showInstrument4, showInstrument5, alertOverbought, alertOversold, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Indicators.Quantum.Quantum_RenkoOptimiser Quantum_RenkoOptimiser(ISeries<double> input , int aTRPeriod, int buttonSize, bool alertOnNewRenko, bool alertOnBullishTrendShift, bool alertOnBearishTrendShift, bool alertOnTrendShift, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_RenkoOptimiser(input, aTRPeriod, buttonSize, alertOnNewRenko, alertOnBullishTrendShift, alertOnBearishTrendShift, alertOnTrendShift, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_TickSpeedometer Quantum_TickSpeedometer(ISeries<double> input , int period, bool dockRight, bool dockDown, bool alertOnCurrentSpeedChange, bool alertOnAverageSpeedChange, bool alertOnFibTickChange, int alertRearmTime, string alertSoundFile, bool alertCurSpeedOnFormingCandle)
		{
			return indicator.Quantum_TickSpeedometer(input, period, dockRight, dockDown, alertOnCurrentSpeedChange, alertOnAverageSpeedChange, alertOnFibTickChange, alertRearmTime, alertSoundFile, alertCurSpeedOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_TrendMonitor Quantum_TrendMonitor(ISeries<double> input , int tolerance, bool showTrendLine, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return indicator.Quantum_TrendMonitor(input, tolerance, showTrendLine, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_Trends Quantum_Trends(ISeries<double> input , int sensitivityToCongestion, bool alertTrendChange, int alertRearmTime, string alertSoundFile, bool alertOnFormingCandle)
		{
			return indicator.Quantum_Trends(input, sensitivityToCongestion, alertTrendChange, alertRearmTime, alertSoundFile, alertOnFormingCandle);
		}

		public Indicators.Quantum.Quantum_USDX Quantum_USDX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QTPriceType priceType, bool alertOnMACross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_USDX(input, lookBack, mA1Period, mA2Period, priceType, alertOnMACross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_Volume Quantum_Volume(ISeries<double> input , bool displayHighVolumeLine, bool displayLowVolumeLine, bool alertHighVolume, bool alertLowVolume, bool alertAveVolume, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_Volume(input, displayHighVolumeLine, displayLowVolumeLine, alertHighVolume, alertLowVolume, alertAveVolume, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_VPOC Quantum_VPOC(ISeries<double> input , bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, bool displayLeft, int lookBackPeriod, int regionCount, VPOCSRLineCount sRLineCount, bool alertVPOCCross, bool alertHVNLVNCross, int alertRearmTime, string alertSoundFile)
		{
			return indicator.Quantum_VPOC(input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, displayLeft, lookBackPeriod, regionCount, sRLineCount, alertVPOCCross, alertHVNLVNCross, alertRearmTime, alertSoundFile);
		}

		public Indicators.Quantum.Quantum_VRSI Quantum_VRSI(ISeries<double> input , int period, bool alertSentiment, bool alertZeroCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_VRSI(input, period, alertSentiment, alertZeroCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

		public Indicators.Quantum.Quantum_VWAPPro Quantum_VWAPPro(ISeries<double> input , QTWAPTypes wAPType, int wAPOpacity, bool showULB, bool fillRegions, double multiplier, string wAPID, int mVWAPPeriod, int mVWAPStdDevPeriod, int tWAPPeriod, int tWAPStdDevPeriod, QTWAPPeriod wAPPeriod, bool alertCrosses, int alertRearmTime, string alertSoundFile, bool alertConfirmedOnly)
		{
			return indicator.Quantum_VWAPPro(input, wAPType, wAPOpacity, showULB, fillRegions, multiplier, wAPID, mVWAPPeriod, mVWAPStdDevPeriod, tWAPPeriod, tWAPStdDevPeriod, wAPPeriod, alertCrosses, alertRearmTime, alertSoundFile, alertConfirmedOnly);
		}

	}
}

#endregion
