#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private QuantumCSI[] cacheQuantumCSI;
		private QuantumCurrencyArray[] cacheQuantumCurrencyArray;
		private QuantumCurrencyHeatmap[] cacheQuantumCurrencyHeatmap;
		private QuantumCurrencyMatrix[] cacheQuantumCurrencyMatrix;
		private QuantumDynamicAccumulationAndDistribution[] cacheQuantumDynamicAccumulationAndDistribution;
		private QuantumDynamicPricePivots[] cacheQuantumDynamicPricePivots;
		private QuantumDynamicVolatility[] cacheQuantumDynamicVolatility;
		private QuantumEURX[] cacheQuantumEURX;
		private QuantumGBPX[] cacheQuantumGBPX;
		private QuantumJPYX[] cacheQuantumJPYX;
		private QuantumLiveCamarillaLevels[] cacheQuantumLiveCamarillaLevels;
		private QuantumRenkoOptimiser[] cacheQuantumRenkoOptimiser;
		private QuantumTickSpeedometer[] cacheQuantumTickSpeedometer;
		private QuantumTrendMonitor[] cacheQuantumTrendMonitor;
		private QuantumTrends[] cacheQuantumTrends;
		private QuantumUSDX[] cacheQuantumUSDX;
		private QuantumVPOC[] cacheQuantumVPOC;

		
		public QuantumCSI QuantumCSI(int period, int barsAgo, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool detectCrosses)
		{
			return QuantumCSI(Input, period, barsAgo, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, detectCrosses);
		}

		public QuantumCurrencyArray QuantumCurrencyArray(int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs)
		{
			return QuantumCurrencyArray(Input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs);
		}

		public QuantumCurrencyHeatmap QuantumCurrencyHeatmap(int lookBack, string bookmarkedCurrencyPairs)
		{
			return QuantumCurrencyHeatmap(Input, lookBack, bookmarkedCurrencyPairs);
		}

		public QuantumCurrencyMatrix QuantumCurrencyMatrix(int lookBack, bool classicColors, string bookmarkedCurrencyPairs)
		{
			return QuantumCurrencyMatrix(Input, lookBack, classicColors, bookmarkedCurrencyPairs);
		}

		public QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle)
		{
			return QuantumDynamicAccumulationAndDistribution(Input, period, offset, labelPosition, clusterFactor, lineStyle);
		}

		public QuantumDynamicPricePivots QuantumDynamicPricePivots(int offset, bool enableAlerts)
		{
			return QuantumDynamicPricePivots(Input, offset, enableAlerts);
		}

		public QuantumDynamicVolatility QuantumDynamicVolatility(int offset, int sensitivity, bool enableAlerts)
		{
			return QuantumDynamicVolatility(Input, offset, sensitivity, enableAlerts);
		}

		public QuantumEURX QuantumEURX(int lookBack, int mA1Period, int mA2Period, QuantumEURXPriceType2 priceType)
		{
			return QuantumEURX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public QuantumGBPX QuantumGBPX(int lookBack, int mA1Period, int mA2Period, QuantumGBPXPriceType priceType)
		{
			return QuantumGBPX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public QuantumJPYX QuantumJPYX(int lookBack, int mA1Period, int mA2Period, QuantumJPYXPriceType2 priceType)
		{
			return QuantumJPYX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public QuantumLiveCamarillaLevels QuantumLiveCamarillaLevels(bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor)
		{
			return QuantumLiveCamarillaLevels(Input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor);
		}

		public QuantumRenkoOptimiser QuantumRenkoOptimiser(int aTRPeriod)
		{
			return QuantumRenkoOptimiser(Input, aTRPeriod);
		}

		public QuantumTickSpeedometer QuantumTickSpeedometer(int period, bool alertOnSpeedChange)
		{
			return QuantumTickSpeedometer(Input, period, alertOnSpeedChange);
		}

		public QuantumTrendMonitor QuantumTrendMonitor(double sensitivityToCongestion, bool showMomentumLine)
		{
			return QuantumTrendMonitor(Input, sensitivityToCongestion, showMomentumLine);
		}

		public QuantumTrends QuantumTrends(double sensitivityToCongestion)
		{
			return QuantumTrends(Input, sensitivityToCongestion);
		}

		public QuantumUSDX QuantumUSDX(int lookBack, int mA1Period, int mA2Period, QuantumUSDXPriceType priceType)
		{
			return QuantumUSDX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public QuantumVPOC QuantumVPOC(bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, int lookBackPeriod, int regionCount, QuantumVPOCSR3LineCount sRLineCount)
		{
			return QuantumVPOC(Input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, lookBackPeriod, regionCount, sRLineCount);
		}


		
		public QuantumCSI QuantumCSI(ISeries<double> input, int period, int barsAgo, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool detectCrosses)
		{
			if (cacheQuantumCSI != null)
				for (int idx = 0; idx < cacheQuantumCSI.Length; idx++)
					if (cacheQuantumCSI[idx].Period == period && cacheQuantumCSI[idx].BarsAgo == barsAgo && cacheQuantumCSI[idx].ShowUSD == showUSD && cacheQuantumCSI[idx].ShowEUR == showEUR && cacheQuantumCSI[idx].ShowGBP == showGBP && cacheQuantumCSI[idx].ShowCHF == showCHF && cacheQuantumCSI[idx].ShowJPY == showJPY && cacheQuantumCSI[idx].ShowCAD == showCAD && cacheQuantumCSI[idx].ShowAUD == showAUD && cacheQuantumCSI[idx].ShowNZD == showNZD && cacheQuantumCSI[idx].DetectCrosses == detectCrosses && cacheQuantumCSI[idx].EqualsInput(input))
						return cacheQuantumCSI[idx];
			return CacheIndicator<QuantumCSI>(new QuantumCSI(){ Period = period, BarsAgo = barsAgo, ShowUSD = showUSD, ShowEUR = showEUR, ShowGBP = showGBP, ShowCHF = showCHF, ShowJPY = showJPY, ShowCAD = showCAD, ShowAUD = showAUD, ShowNZD = showNZD, DetectCrosses = detectCrosses }, input, ref cacheQuantumCSI);
		}

		public QuantumCurrencyArray QuantumCurrencyArray(ISeries<double> input, int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs)
		{
			if (cacheQuantumCurrencyArray != null)
				for (int idx = 0; idx < cacheQuantumCurrencyArray.Length; idx++)
					if (cacheQuantumCurrencyArray[idx].LookBack == lookBack && cacheQuantumCurrencyArray[idx].OBOSPeriod == oBOSPeriod && cacheQuantumCurrencyArray[idx].BookmarkedCurrencyPairs == bookmarkedCurrencyPairs && cacheQuantumCurrencyArray[idx].EqualsInput(input))
						return cacheQuantumCurrencyArray[idx];
			return CacheIndicator<QuantumCurrencyArray>(new QuantumCurrencyArray(){ LookBack = lookBack, OBOSPeriod = oBOSPeriod, BookmarkedCurrencyPairs = bookmarkedCurrencyPairs }, input, ref cacheQuantumCurrencyArray);
		}

		public QuantumCurrencyHeatmap QuantumCurrencyHeatmap(ISeries<double> input, int lookBack, string bookmarkedCurrencyPairs)
		{
			if (cacheQuantumCurrencyHeatmap != null)
				for (int idx = 0; idx < cacheQuantumCurrencyHeatmap.Length; idx++)
					if (cacheQuantumCurrencyHeatmap[idx].LookBack == lookBack && cacheQuantumCurrencyHeatmap[idx].BookmarkedCurrencyPairs == bookmarkedCurrencyPairs && cacheQuantumCurrencyHeatmap[idx].EqualsInput(input))
						return cacheQuantumCurrencyHeatmap[idx];
			return CacheIndicator<QuantumCurrencyHeatmap>(new QuantumCurrencyHeatmap(){ LookBack = lookBack, BookmarkedCurrencyPairs = bookmarkedCurrencyPairs }, input, ref cacheQuantumCurrencyHeatmap);
		}

		public QuantumCurrencyMatrix QuantumCurrencyMatrix(ISeries<double> input, int lookBack, bool classicColors, string bookmarkedCurrencyPairs)
		{
			if (cacheQuantumCurrencyMatrix != null)
				for (int idx = 0; idx < cacheQuantumCurrencyMatrix.Length; idx++)
					if (cacheQuantumCurrencyMatrix[idx].LookBack == lookBack && cacheQuantumCurrencyMatrix[idx].ClassicColors == classicColors && cacheQuantumCurrencyMatrix[idx].BookmarkedCurrencyPairs == bookmarkedCurrencyPairs && cacheQuantumCurrencyMatrix[idx].EqualsInput(input))
						return cacheQuantumCurrencyMatrix[idx];
			return CacheIndicator<QuantumCurrencyMatrix>(new QuantumCurrencyMatrix(){ LookBack = lookBack, ClassicColors = classicColors, BookmarkedCurrencyPairs = bookmarkedCurrencyPairs }, input, ref cacheQuantumCurrencyMatrix);
		}

		public QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(ISeries<double> input, int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle)
		{
			if (cacheQuantumDynamicAccumulationAndDistribution != null)
				for (int idx = 0; idx < cacheQuantumDynamicAccumulationAndDistribution.Length; idx++)
					if (cacheQuantumDynamicAccumulationAndDistribution[idx].Period == period && cacheQuantumDynamicAccumulationAndDistribution[idx].Offset == offset && cacheQuantumDynamicAccumulationAndDistribution[idx].LabelPosition == labelPosition && cacheQuantumDynamicAccumulationAndDistribution[idx].ClusterFactor == clusterFactor && cacheQuantumDynamicAccumulationAndDistribution[idx].LineStyle == lineStyle && cacheQuantumDynamicAccumulationAndDistribution[idx].EqualsInput(input))
						return cacheQuantumDynamicAccumulationAndDistribution[idx];
			return CacheIndicator<QuantumDynamicAccumulationAndDistribution>(new QuantumDynamicAccumulationAndDistribution(){ Period = period, Offset = offset, LabelPosition = labelPosition, ClusterFactor = clusterFactor, LineStyle = lineStyle }, input, ref cacheQuantumDynamicAccumulationAndDistribution);
		}

		public QuantumDynamicPricePivots QuantumDynamicPricePivots(ISeries<double> input, int offset, bool enableAlerts)
		{
			if (cacheQuantumDynamicPricePivots != null)
				for (int idx = 0; idx < cacheQuantumDynamicPricePivots.Length; idx++)
					if (cacheQuantumDynamicPricePivots[idx].Offset == offset && cacheQuantumDynamicPricePivots[idx].EnableAlerts == enableAlerts && cacheQuantumDynamicPricePivots[idx].EqualsInput(input))
						return cacheQuantumDynamicPricePivots[idx];
			return CacheIndicator<QuantumDynamicPricePivots>(new QuantumDynamicPricePivots(){ Offset = offset, EnableAlerts = enableAlerts }, input, ref cacheQuantumDynamicPricePivots);
		}

		public QuantumDynamicVolatility QuantumDynamicVolatility(ISeries<double> input, int offset, int sensitivity, bool enableAlerts)
		{
			if (cacheQuantumDynamicVolatility != null)
				for (int idx = 0; idx < cacheQuantumDynamicVolatility.Length; idx++)
					if (cacheQuantumDynamicVolatility[idx].Offset == offset && cacheQuantumDynamicVolatility[idx].Sensitivity == sensitivity && cacheQuantumDynamicVolatility[idx].EnableAlerts == enableAlerts && cacheQuantumDynamicVolatility[idx].EqualsInput(input))
						return cacheQuantumDynamicVolatility[idx];
			return CacheIndicator<QuantumDynamicVolatility>(new QuantumDynamicVolatility(){ Offset = offset, Sensitivity = sensitivity, EnableAlerts = enableAlerts }, input, ref cacheQuantumDynamicVolatility);
		}

		public QuantumEURX QuantumEURX(ISeries<double> input, int lookBack, int mA1Period, int mA2Period, QuantumEURXPriceType2 priceType)
		{
			if (cacheQuantumEURX != null)
				for (int idx = 0; idx < cacheQuantumEURX.Length; idx++)
					if (cacheQuantumEURX[idx].LookBack == lookBack && cacheQuantumEURX[idx].MA1Period == mA1Period && cacheQuantumEURX[idx].MA2Period == mA2Period && cacheQuantumEURX[idx].PriceType == priceType && cacheQuantumEURX[idx].EqualsInput(input))
						return cacheQuantumEURX[idx];
			return CacheIndicator<QuantumEURX>(new QuantumEURX(){ LookBack = lookBack, MA1Period = mA1Period, MA2Period = mA2Period, PriceType = priceType }, input, ref cacheQuantumEURX);
		}

		public QuantumGBPX QuantumGBPX(ISeries<double> input, int lookBack, int mA1Period, int mA2Period, QuantumGBPXPriceType priceType)
		{
			if (cacheQuantumGBPX != null)
				for (int idx = 0; idx < cacheQuantumGBPX.Length; idx++)
					if (cacheQuantumGBPX[idx].LookBack == lookBack && cacheQuantumGBPX[idx].MA1Period == mA1Period && cacheQuantumGBPX[idx].MA2Period == mA2Period && cacheQuantumGBPX[idx].PriceType == priceType && cacheQuantumGBPX[idx].EqualsInput(input))
						return cacheQuantumGBPX[idx];
			return CacheIndicator<QuantumGBPX>(new QuantumGBPX(){ LookBack = lookBack, MA1Period = mA1Period, MA2Period = mA2Period, PriceType = priceType }, input, ref cacheQuantumGBPX);
		}

		public QuantumJPYX QuantumJPYX(ISeries<double> input, int lookBack, int mA1Period, int mA2Period, QuantumJPYXPriceType2 priceType)
		{
			if (cacheQuantumJPYX != null)
				for (int idx = 0; idx < cacheQuantumJPYX.Length; idx++)
					if (cacheQuantumJPYX[idx].LookBack == lookBack && cacheQuantumJPYX[idx].MA1Period == mA1Period && cacheQuantumJPYX[idx].MA2Period == mA2Period && cacheQuantumJPYX[idx].PriceType == priceType && cacheQuantumJPYX[idx].EqualsInput(input))
						return cacheQuantumJPYX[idx];
			return CacheIndicator<QuantumJPYX>(new QuantumJPYX(){ LookBack = lookBack, MA1Period = mA1Period, MA2Period = mA2Period, PriceType = priceType }, input, ref cacheQuantumJPYX);
		}

		public QuantumLiveCamarillaLevels QuantumLiveCamarillaLevels(ISeries<double> input, bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor)
		{
			if (cacheQuantumLiveCamarillaLevels != null)
				for (int idx = 0; idx < cacheQuantumLiveCamarillaLevels.Length; idx++)
					if (cacheQuantumLiveCamarillaLevels[idx].Analyze == analyze && cacheQuantumLiveCamarillaLevels[idx].ShowLabels == showLabels && cacheQuantumLiveCamarillaLevels[idx].LineThickness == lineThickness && cacheQuantumLiveCamarillaLevels[idx].LabelHorizontalOffset == labelHorizontalOffset && cacheQuantumLiveCamarillaLevels[idx].LabelVerticalOffset == labelVerticalOffset && cacheQuantumLiveCamarillaLevels[idx].LabelFontSize == labelFontSize && cacheQuantumLiveCamarillaLevels[idx].AnalysisBoxFontSize == analysisBoxFontSize && cacheQuantumLiveCamarillaLevels[idx].S1R1Color == s1R1Color && cacheQuantumLiveCamarillaLevels[idx].S2R2Color == s2R2Color && cacheQuantumLiveCamarillaLevels[idx].S3R3Color == s3R3Color && cacheQuantumLiveCamarillaLevels[idx].S4R4Color == s4R4Color && cacheQuantumLiveCamarillaLevels[idx].S5R5Color == s5R5Color && cacheQuantumLiveCamarillaLevels[idx].S6R6Color == s6R6Color && cacheQuantumLiveCamarillaLevels[idx].BoxColor == boxColor && cacheQuantumLiveCamarillaLevels[idx].BoxFontColor == boxFontColor && cacheQuantumLiveCamarillaLevels[idx].EqualsInput(input))
						return cacheQuantumLiveCamarillaLevels[idx];
			return CacheIndicator<QuantumLiveCamarillaLevels>(new QuantumLiveCamarillaLevels(){ Analyze = analyze, ShowLabels = showLabels, LineThickness = lineThickness, LabelHorizontalOffset = labelHorizontalOffset, LabelVerticalOffset = labelVerticalOffset, LabelFontSize = labelFontSize, AnalysisBoxFontSize = analysisBoxFontSize, S1R1Color = s1R1Color, S2R2Color = s2R2Color, S3R3Color = s3R3Color, S4R4Color = s4R4Color, S5R5Color = s5R5Color, S6R6Color = s6R6Color, BoxColor = boxColor, BoxFontColor = boxFontColor }, input, ref cacheQuantumLiveCamarillaLevels);
		}

		public QuantumRenkoOptimiser QuantumRenkoOptimiser(ISeries<double> input, int aTRPeriod)
		{
			if (cacheQuantumRenkoOptimiser != null)
				for (int idx = 0; idx < cacheQuantumRenkoOptimiser.Length; idx++)
					if (cacheQuantumRenkoOptimiser[idx].ATRPeriod == aTRPeriod && cacheQuantumRenkoOptimiser[idx].EqualsInput(input))
						return cacheQuantumRenkoOptimiser[idx];
			return CacheIndicator<QuantumRenkoOptimiser>(new QuantumRenkoOptimiser(){ ATRPeriod = aTRPeriod }, input, ref cacheQuantumRenkoOptimiser);
		}

		public QuantumTickSpeedometer QuantumTickSpeedometer(ISeries<double> input, int period, bool alertOnSpeedChange)
		{
			if (cacheQuantumTickSpeedometer != null)
				for (int idx = 0; idx < cacheQuantumTickSpeedometer.Length; idx++)
					if (cacheQuantumTickSpeedometer[idx].Period == period && cacheQuantumTickSpeedometer[idx].AlertOnSpeedChange == alertOnSpeedChange && cacheQuantumTickSpeedometer[idx].EqualsInput(input))
						return cacheQuantumTickSpeedometer[idx];
			return CacheIndicator<QuantumTickSpeedometer>(new QuantumTickSpeedometer(){ Period = period, AlertOnSpeedChange = alertOnSpeedChange }, input, ref cacheQuantumTickSpeedometer);
		}

		public QuantumTrendMonitor QuantumTrendMonitor(ISeries<double> input, double sensitivityToCongestion, bool showMomentumLine)
		{
			if (cacheQuantumTrendMonitor != null)
				for (int idx = 0; idx < cacheQuantumTrendMonitor.Length; idx++)
					if (cacheQuantumTrendMonitor[idx].SensitivityToCongestion == sensitivityToCongestion && cacheQuantumTrendMonitor[idx].ShowMomentumLine == showMomentumLine && cacheQuantumTrendMonitor[idx].EqualsInput(input))
						return cacheQuantumTrendMonitor[idx];
			return CacheIndicator<QuantumTrendMonitor>(new QuantumTrendMonitor(){ SensitivityToCongestion = sensitivityToCongestion, ShowMomentumLine = showMomentumLine }, input, ref cacheQuantumTrendMonitor);
		}

		public QuantumTrends QuantumTrends(ISeries<double> input, double sensitivityToCongestion)
		{
			if (cacheQuantumTrends != null)
				for (int idx = 0; idx < cacheQuantumTrends.Length; idx++)
					if (cacheQuantumTrends[idx].SensitivityToCongestion == sensitivityToCongestion && cacheQuantumTrends[idx].EqualsInput(input))
						return cacheQuantumTrends[idx];
			return CacheIndicator<QuantumTrends>(new QuantumTrends(){ SensitivityToCongestion = sensitivityToCongestion }, input, ref cacheQuantumTrends);
		}

		public QuantumUSDX QuantumUSDX(ISeries<double> input, int lookBack, int mA1Period, int mA2Period, QuantumUSDXPriceType priceType)
		{
			if (cacheQuantumUSDX != null)
				for (int idx = 0; idx < cacheQuantumUSDX.Length; idx++)
					if (cacheQuantumUSDX[idx].LookBack == lookBack && cacheQuantumUSDX[idx].MA1Period == mA1Period && cacheQuantumUSDX[idx].MA2Period == mA2Period && cacheQuantumUSDX[idx].PriceType == priceType && cacheQuantumUSDX[idx].EqualsInput(input))
						return cacheQuantumUSDX[idx];
			return CacheIndicator<QuantumUSDX>(new QuantumUSDX(){ LookBack = lookBack, MA1Period = mA1Period, MA2Period = mA2Period, PriceType = priceType }, input, ref cacheQuantumUSDX);
		}

		public QuantumVPOC QuantumVPOC(ISeries<double> input, bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, int lookBackPeriod, int regionCount, QuantumVPOCSR3LineCount sRLineCount)
		{
			if (cacheQuantumVPOC != null)
				for (int idx = 0; idx < cacheQuantumVPOC.Length; idx++)
					if (cacheQuantumVPOC[idx].ShowSupportResistance == showSupportResistance && cacheQuantumVPOC[idx].ShowVolumePointOfControl == showVolumePointOfControl && cacheQuantumVPOC[idx].ShowVolumeProfile == showVolumeProfile && cacheQuantumVPOC[idx].LookBackPeriod == lookBackPeriod && cacheQuantumVPOC[idx].RegionCount == regionCount && cacheQuantumVPOC[idx].SRLineCount == sRLineCount && cacheQuantumVPOC[idx].EqualsInput(input))
						return cacheQuantumVPOC[idx];
			return CacheIndicator<QuantumVPOC>(new QuantumVPOC(){ ShowSupportResistance = showSupportResistance, ShowVolumePointOfControl = showVolumePointOfControl, ShowVolumeProfile = showVolumeProfile, LookBackPeriod = lookBackPeriod, RegionCount = regionCount, SRLineCount = sRLineCount }, input, ref cacheQuantumVPOC);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.QuantumCSI QuantumCSI(int period, int barsAgo, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool detectCrosses)
		{
			return indicator.QuantumCSI(Input, period, barsAgo, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, detectCrosses);
		}

		public Indicators.QuantumCurrencyArray QuantumCurrencyArray(int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyArray(Input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumCurrencyHeatmap QuantumCurrencyHeatmap(int lookBack, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyHeatmap(Input, lookBack, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumCurrencyMatrix QuantumCurrencyMatrix(int lookBack, bool classicColors, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyMatrix(Input, lookBack, classicColors, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle)
		{
			return indicator.QuantumDynamicAccumulationAndDistribution(Input, period, offset, labelPosition, clusterFactor, lineStyle);
		}

		public Indicators.QuantumDynamicPricePivots QuantumDynamicPricePivots(int offset, bool enableAlerts)
		{
			return indicator.QuantumDynamicPricePivots(Input, offset, enableAlerts);
		}

		public Indicators.QuantumDynamicVolatility QuantumDynamicVolatility(int offset, int sensitivity, bool enableAlerts)
		{
			return indicator.QuantumDynamicVolatility(Input, offset, sensitivity, enableAlerts);
		}

		public Indicators.QuantumEURX QuantumEURX(int lookBack, int mA1Period, int mA2Period, QuantumEURXPriceType2 priceType)
		{
			return indicator.QuantumEURX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumGBPX QuantumGBPX(int lookBack, int mA1Period, int mA2Period, QuantumGBPXPriceType priceType)
		{
			return indicator.QuantumGBPX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumJPYX QuantumJPYX(int lookBack, int mA1Period, int mA2Period, QuantumJPYXPriceType2 priceType)
		{
			return indicator.QuantumJPYX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumLiveCamarillaLevels QuantumLiveCamarillaLevels(bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor)
		{
			return indicator.QuantumLiveCamarillaLevels(Input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor);
		}

		public Indicators.QuantumRenkoOptimiser QuantumRenkoOptimiser(int aTRPeriod)
		{
			return indicator.QuantumRenkoOptimiser(Input, aTRPeriod);
		}

		public Indicators.QuantumTickSpeedometer QuantumTickSpeedometer(int period, bool alertOnSpeedChange)
		{
			return indicator.QuantumTickSpeedometer(Input, period, alertOnSpeedChange);
		}

		public Indicators.QuantumTrendMonitor QuantumTrendMonitor(double sensitivityToCongestion, bool showMomentumLine)
		{
			return indicator.QuantumTrendMonitor(Input, sensitivityToCongestion, showMomentumLine);
		}

		public Indicators.QuantumTrends QuantumTrends(double sensitivityToCongestion)
		{
			return indicator.QuantumTrends(Input, sensitivityToCongestion);
		}

		public Indicators.QuantumUSDX QuantumUSDX(int lookBack, int mA1Period, int mA2Period, QuantumUSDXPriceType priceType)
		{
			return indicator.QuantumUSDX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumVPOC QuantumVPOC(bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, int lookBackPeriod, int regionCount, QuantumVPOCSR3LineCount sRLineCount)
		{
			return indicator.QuantumVPOC(Input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, lookBackPeriod, regionCount, sRLineCount);
		}


		
		public Indicators.QuantumCSI QuantumCSI(ISeries<double> input , int period, int barsAgo, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool detectCrosses)
		{
			return indicator.QuantumCSI(input, period, barsAgo, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, detectCrosses);
		}

		public Indicators.QuantumCurrencyArray QuantumCurrencyArray(ISeries<double> input , int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyArray(input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumCurrencyHeatmap QuantumCurrencyHeatmap(ISeries<double> input , int lookBack, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyHeatmap(input, lookBack, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumCurrencyMatrix QuantumCurrencyMatrix(ISeries<double> input , int lookBack, bool classicColors, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyMatrix(input, lookBack, classicColors, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(ISeries<double> input , int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle)
		{
			return indicator.QuantumDynamicAccumulationAndDistribution(input, period, offset, labelPosition, clusterFactor, lineStyle);
		}

		public Indicators.QuantumDynamicPricePivots QuantumDynamicPricePivots(ISeries<double> input , int offset, bool enableAlerts)
		{
			return indicator.QuantumDynamicPricePivots(input, offset, enableAlerts);
		}

		public Indicators.QuantumDynamicVolatility QuantumDynamicVolatility(ISeries<double> input , int offset, int sensitivity, bool enableAlerts)
		{
			return indicator.QuantumDynamicVolatility(input, offset, sensitivity, enableAlerts);
		}

		public Indicators.QuantumEURX QuantumEURX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QuantumEURXPriceType2 priceType)
		{
			return indicator.QuantumEURX(input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumGBPX QuantumGBPX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QuantumGBPXPriceType priceType)
		{
			return indicator.QuantumGBPX(input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumJPYX QuantumJPYX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QuantumJPYXPriceType2 priceType)
		{
			return indicator.QuantumJPYX(input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumLiveCamarillaLevels QuantumLiveCamarillaLevels(ISeries<double> input , bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor)
		{
			return indicator.QuantumLiveCamarillaLevels(input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor);
		}

		public Indicators.QuantumRenkoOptimiser QuantumRenkoOptimiser(ISeries<double> input , int aTRPeriod)
		{
			return indicator.QuantumRenkoOptimiser(input, aTRPeriod);
		}

		public Indicators.QuantumTickSpeedometer QuantumTickSpeedometer(ISeries<double> input , int period, bool alertOnSpeedChange)
		{
			return indicator.QuantumTickSpeedometer(input, period, alertOnSpeedChange);
		}

		public Indicators.QuantumTrendMonitor QuantumTrendMonitor(ISeries<double> input , double sensitivityToCongestion, bool showMomentumLine)
		{
			return indicator.QuantumTrendMonitor(input, sensitivityToCongestion, showMomentumLine);
		}

		public Indicators.QuantumTrends QuantumTrends(ISeries<double> input , double sensitivityToCongestion)
		{
			return indicator.QuantumTrends(input, sensitivityToCongestion);
		}

		public Indicators.QuantumUSDX QuantumUSDX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QuantumUSDXPriceType priceType)
		{
			return indicator.QuantumUSDX(input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumVPOC QuantumVPOC(ISeries<double> input , bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, int lookBackPeriod, int regionCount, QuantumVPOCSR3LineCount sRLineCount)
		{
			return indicator.QuantumVPOC(input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, lookBackPeriod, regionCount, sRLineCount);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.QuantumCSI QuantumCSI(int period, int barsAgo, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool detectCrosses)
		{
			return indicator.QuantumCSI(Input, period, barsAgo, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, detectCrosses);
		}

		public Indicators.QuantumCurrencyArray QuantumCurrencyArray(int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyArray(Input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumCurrencyHeatmap QuantumCurrencyHeatmap(int lookBack, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyHeatmap(Input, lookBack, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumCurrencyMatrix QuantumCurrencyMatrix(int lookBack, bool classicColors, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyMatrix(Input, lookBack, classicColors, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle)
		{
			return indicator.QuantumDynamicAccumulationAndDistribution(Input, period, offset, labelPosition, clusterFactor, lineStyle);
		}

		public Indicators.QuantumDynamicPricePivots QuantumDynamicPricePivots(int offset, bool enableAlerts)
		{
			return indicator.QuantumDynamicPricePivots(Input, offset, enableAlerts);
		}

		public Indicators.QuantumDynamicVolatility QuantumDynamicVolatility(int offset, int sensitivity, bool enableAlerts)
		{
			return indicator.QuantumDynamicVolatility(Input, offset, sensitivity, enableAlerts);
		}

		public Indicators.QuantumEURX QuantumEURX(int lookBack, int mA1Period, int mA2Period, QuantumEURXPriceType2 priceType)
		{
			return indicator.QuantumEURX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumGBPX QuantumGBPX(int lookBack, int mA1Period, int mA2Period, QuantumGBPXPriceType priceType)
		{
			return indicator.QuantumGBPX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumJPYX QuantumJPYX(int lookBack, int mA1Period, int mA2Period, QuantumJPYXPriceType2 priceType)
		{
			return indicator.QuantumJPYX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumLiveCamarillaLevels QuantumLiveCamarillaLevels(bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor)
		{
			return indicator.QuantumLiveCamarillaLevels(Input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor);
		}

		public Indicators.QuantumRenkoOptimiser QuantumRenkoOptimiser(int aTRPeriod)
		{
			return indicator.QuantumRenkoOptimiser(Input, aTRPeriod);
		}

		public Indicators.QuantumTickSpeedometer QuantumTickSpeedometer(int period, bool alertOnSpeedChange)
		{
			return indicator.QuantumTickSpeedometer(Input, period, alertOnSpeedChange);
		}

		public Indicators.QuantumTrendMonitor QuantumTrendMonitor(double sensitivityToCongestion, bool showMomentumLine)
		{
			return indicator.QuantumTrendMonitor(Input, sensitivityToCongestion, showMomentumLine);
		}

		public Indicators.QuantumTrends QuantumTrends(double sensitivityToCongestion)
		{
			return indicator.QuantumTrends(Input, sensitivityToCongestion);
		}

		public Indicators.QuantumUSDX QuantumUSDX(int lookBack, int mA1Period, int mA2Period, QuantumUSDXPriceType priceType)
		{
			return indicator.QuantumUSDX(Input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumVPOC QuantumVPOC(bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, int lookBackPeriod, int regionCount, QuantumVPOCSR3LineCount sRLineCount)
		{
			return indicator.QuantumVPOC(Input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, lookBackPeriod, regionCount, sRLineCount);
		}


		
		public Indicators.QuantumCSI QuantumCSI(ISeries<double> input , int period, int barsAgo, bool showUSD, bool showEUR, bool showGBP, bool showCHF, bool showJPY, bool showCAD, bool showAUD, bool showNZD, bool detectCrosses)
		{
			return indicator.QuantumCSI(input, period, barsAgo, showUSD, showEUR, showGBP, showCHF, showJPY, showCAD, showAUD, showNZD, detectCrosses);
		}

		public Indicators.QuantumCurrencyArray QuantumCurrencyArray(ISeries<double> input , int lookBack, int oBOSPeriod, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyArray(input, lookBack, oBOSPeriod, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumCurrencyHeatmap QuantumCurrencyHeatmap(ISeries<double> input , int lookBack, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyHeatmap(input, lookBack, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumCurrencyMatrix QuantumCurrencyMatrix(ISeries<double> input , int lookBack, bool classicColors, string bookmarkedCurrencyPairs)
		{
			return indicator.QuantumCurrencyMatrix(input, lookBack, classicColors, bookmarkedCurrencyPairs);
		}

		public Indicators.QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(ISeries<double> input , int period, int offset, int labelPosition, double clusterFactor, NinjaTrader.Gui.DashStyleHelper lineStyle)
		{
			return indicator.QuantumDynamicAccumulationAndDistribution(input, period, offset, labelPosition, clusterFactor, lineStyle);
		}

		public Indicators.QuantumDynamicPricePivots QuantumDynamicPricePivots(ISeries<double> input , int offset, bool enableAlerts)
		{
			return indicator.QuantumDynamicPricePivots(input, offset, enableAlerts);
		}

		public Indicators.QuantumDynamicVolatility QuantumDynamicVolatility(ISeries<double> input , int offset, int sensitivity, bool enableAlerts)
		{
			return indicator.QuantumDynamicVolatility(input, offset, sensitivity, enableAlerts);
		}

		public Indicators.QuantumEURX QuantumEURX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QuantumEURXPriceType2 priceType)
		{
			return indicator.QuantumEURX(input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumGBPX QuantumGBPX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QuantumGBPXPriceType priceType)
		{
			return indicator.QuantumGBPX(input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumJPYX QuantumJPYX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QuantumJPYXPriceType2 priceType)
		{
			return indicator.QuantumJPYX(input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumLiveCamarillaLevels QuantumLiveCamarillaLevels(ISeries<double> input , bool analyze, bool showLabels, int lineThickness, int labelHorizontalOffset, int labelVerticalOffset, int labelFontSize, int analysisBoxFontSize, Brush s1R1Color, Brush s2R2Color, Brush s3R3Color, Brush s4R4Color, Brush s5R5Color, Brush s6R6Color, Brush boxColor, Brush boxFontColor)
		{
			return indicator.QuantumLiveCamarillaLevels(input, analyze, showLabels, lineThickness, labelHorizontalOffset, labelVerticalOffset, labelFontSize, analysisBoxFontSize, s1R1Color, s2R2Color, s3R3Color, s4R4Color, s5R5Color, s6R6Color, boxColor, boxFontColor);
		}

		public Indicators.QuantumRenkoOptimiser QuantumRenkoOptimiser(ISeries<double> input , int aTRPeriod)
		{
			return indicator.QuantumRenkoOptimiser(input, aTRPeriod);
		}

		public Indicators.QuantumTickSpeedometer QuantumTickSpeedometer(ISeries<double> input , int period, bool alertOnSpeedChange)
		{
			return indicator.QuantumTickSpeedometer(input, period, alertOnSpeedChange);
		}

		public Indicators.QuantumTrendMonitor QuantumTrendMonitor(ISeries<double> input , double sensitivityToCongestion, bool showMomentumLine)
		{
			return indicator.QuantumTrendMonitor(input, sensitivityToCongestion, showMomentumLine);
		}

		public Indicators.QuantumTrends QuantumTrends(ISeries<double> input , double sensitivityToCongestion)
		{
			return indicator.QuantumTrends(input, sensitivityToCongestion);
		}

		public Indicators.QuantumUSDX QuantumUSDX(ISeries<double> input , int lookBack, int mA1Period, int mA2Period, QuantumUSDXPriceType priceType)
		{
			return indicator.QuantumUSDX(input, lookBack, mA1Period, mA2Period, priceType);
		}

		public Indicators.QuantumVPOC QuantumVPOC(ISeries<double> input , bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, int lookBackPeriod, int regionCount, QuantumVPOCSR3LineCount sRLineCount)
		{
			return indicator.QuantumVPOC(input, showSupportResistance, showVolumePointOfControl, showVolumeProfile, lookBackPeriod, regionCount, sRLineCount);
		}

	}
}

#endregion
